package ru.yandex.reminders.logic.flight;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.reminders.util.BindValueNodeHere;

@BenderBindAllFields
public class FlightCity {
    @BindValueNodeHere
    private final String name;
    private final Option<Integer> geoId;

    public FlightCity(String name) {
        this(name, Option.none());
    }

    public FlightCity(String name, Option<Integer> geoId) {
        this.name = name;
        this.geoId = geoId;
    }

    public String getName() {
        return name;
    }

    public Option<Integer> getGeoId() {
        return geoId;
    }
}
