package ru.yandex.reminders.logic.flight;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.reminders.util.BindValueNodeHere;

@BenderBindAllFields
public class FlightItem {
    @BindValueNodeHere
    private final Option<String> name;
    private final Option<Integer> raspId;
    private final Option<String> icaoCode;
    private final Option<String> iataCode;
    private final Option<String> sirenaCode;

    public FlightItem(String name) {
        this(Option.some(name), Option.none(), Option.none(), Option.none(), Option.none());
    }

    public FlightItem(
            Option<String> name, Option<Integer> raspId,
            Option<String> icaoCode, Option<String> iataCode, Option<String> sirenaCode)
    {
        this.name = name;
        this.raspId = raspId;
        this.icaoCode = icaoCode;
        this.iataCode = iataCode;
        this.sirenaCode = sirenaCode;
    }

    public Option<String> getName() {
        return name;
    }

    public Option<Integer> getRaspId() {
        return raspId;
    }

    public Option<String> getIcaoCode() {
        return icaoCode;
    }

    public Option<String> getIataCode() {
        return iataCode;
    }

    public Option<String> getSirenaCode() {
        return sirenaCode;
    }
}
