package ru.yandex.reminders.logic.flight;

import org.apache.commons.codec.binary.Base64;
import ru.yandex.commune.mail.MailAddress;
import ru.yandex.commune.mail.MailMessage;
import ru.yandex.commune.mail.MailMessageHeader;
import ru.yandex.misc.email.Email;
import ru.yandex.reminders.i18n.Messages;
import ru.yandex.reminders.logic.sending.MailMessageCreator;
import ru.yandex.reminders.logic.sending.emails.FlightEmailInfo;
import ru.yandex.reminders.util.MailUtils;

public class FlightReminderMailMessageCreator {

    private static MailMessageHeader X_YANDEX_HINT_HEADER = new MailMessageHeader("X-Yandex-Hint",
            new String(Base64.encodeBase64("label=SystMetkaSO:eticket\nlabel=SystMetkaSO:s_aviaeticket".getBytes())));


    public static MailMessage create(Email recipientEmail, FlightEventMeta flight) {
        return MailMessageCreator.create(new FlightEmailInfo(flight))
                .withMessageId(MailUtils.EMPTY_MESSAGE_ID)
                .withFrom(new MailAddress(
                        new Email("noreply@" + flight.getYaDomainOrYandexRu()),
                        Messages.M.getMessage("flight.mail.from", flight.getLanguage())))
                .withTo(recipientEmail)
                .addHeader("X-Yandex-Flight-Direction", flight.getDirection().getOrElse("")) // DARIA-25972
                .addHeader(X_YANDEX_HINT_HEADER.getName(), X_YANDEX_HINT_HEADER.getValue()); // DARIA-24825
    }
}
