package ru.yandex.reminders.logic.flight;

import org.joda.time.Duration;
import ru.yandex.bolts.collection.Option;
import ru.yandex.reminders.logic.reminder.PhoneNumber;

public class FlightRemindersInfo {

    private final Option<Duration> userSmsOffset;
    private final Option<PhoneNumber> phone;

    private final Duration availableOffset;

    private final Option<Duration> autoSmsOffset;
    private final Option<Duration> autoEmailOffset;

    public FlightRemindersInfo(
            Option<Duration> userSmsOffset, Option<PhoneNumber> phone, Duration availableOffset,
            Option<Duration> autoSmsOffset, Option<Duration> autoEmailOffset) {
        this.userSmsOffset = userSmsOffset;
        this.phone = phone;
        this.availableOffset = availableOffset;
        this.autoSmsOffset = autoSmsOffset;
        this.autoEmailOffset = autoEmailOffset;
    }

    public Option<PhoneNumber> getPhone() {
        return phone;
    }

    public Option<Duration> getUserSmsOffset() {
        return userSmsOffset;
    }

    public Duration getAvailableOffset() {
        return availableOffset;
    }

    public Option<Duration> getAutoSmsOffset() {
        return autoSmsOffset;
    }

    public Option<Duration> getAutoEmailOffset() {
        return autoEmailOffset;
    }
}
