package ru.yandex.reminders.logic.flight;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

public enum FlightSource implements IntEnum {
    IEX(0), // yet another name for TOMITA
    RASP(1),
    ;

    public static IntEnumResolver<FlightSource> R = IntEnumResolver.r(FlightSource.class);

    private final int value;

    FlightSource(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }
}
