package ru.yandex.reminders.logic.flight.airport;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.worker.DelayingWorkerThread;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class AirportCacheUpdatingWorker extends DelayingWorkerThread {

    @Autowired
    private AirportManager airportManager;


    public AirportCacheUpdatingWorker() {
        super("airport-cache-updating-worker");
    }

    @PostConstruct
    public void onConstruct() {
        startGracefully();
    }

    @PreDestroy
    public void onDestroy() {
        stopGracefully();
    }

    @Override
    protected long delayBetweenExecutionsMillis() {
        // 1/2 * AirportsImportTask cron period + random (for avoiding waiting for lock)
        return Duration.standardHours(12).getMillis() + Random2.R.nextLong(Duration.standardHours(1).getMillis());
    }

    @Override
    protected void executePeriodically() {
        airportManager.updateCache();
    }

}
