package ru.yandex.reminders.logic.flight.airport;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.reminders.api.unistat.UnistatConfiguration;
import ru.yandex.reminders.logic.flight.rasp.RaspClientContextConfiguration;
import ru.yandex.reminders.logic.update.LockManagerContextConfiguration;

@Configuration
@Import({
    LockManagerContextConfiguration.class,
    RaspClientContextConfiguration.class,
    UnistatConfiguration.class
})
public class AirportContextConfiguration {

    @Bean
    public AirportManager airportManager() {
        return new AirportManager();
    }

    @Bean
    public AirportCacheUpdatingWorker airportCacheUpdatingWorker() {
        return new AirportCacheUpdatingWorker();
    }

}
