package ru.yandex.reminders.logic.flight.airport;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;

@Bendable
@BenderMembersToBind(value = MembersToBind.ALL_FIELDS)
public class Country extends Named {

    @BenderPart(name = "geo_id", strictName = true)
    private final Option<Long> geoId;

    public Country(Option<String> name, Option<String> nameEn, Option<String> nameRu, Option<Long> geoId) {
        super(name, nameEn, nameRu);
        this.geoId = geoId;
    }

    public Option<Long> getGeoId() {
        return geoId;
    }
}
