package ru.yandex.reminders.logic.flight.airport;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

@Bendable
@BenderMembersToBind(value = MembersToBind.ALL_FIELDS)
public class Named extends DefaultObject {

    @BenderPart(name = "title", strictName = true)
    private final Option<String> name;
    @BenderPart(name = "title_en", strictName = true)
    private final Option<String> nameEn;
    @BenderPart(name = "title_ru", strictName = true)
    private final Option<String> nameRu;

    public Named(Option<String> name, Option<String> nameEn, Option<String> nameRu) {
        this.name = name;
        this.nameEn = nameEn;
        this.nameRu = nameRu;
    }

    public static Function<Named, Option<String>> getNameEnF() {
        return n -> n.getNameEn();
    }

    public static Function<Named, Option<String>> getNameRuF() {
        return n -> n.getNameRu();
    }

    public Option<String> getName() {
        return name;
    }

    public Option<String> getNameEn() {
        return nameEn;
    }

    public Option<String> getNameRu() {
        return nameRu;
    }
}
