package ru.yandex.reminders.logic.flight.rasp;

import org.apache.http.client.methods.HttpGet;
import org.bson.types.ObjectId;
import org.joda.time.DateTimeZone;
import ru.yandex.commune.mongo3.bender.MongoObjectIdMarshaller;
import ru.yandex.commune.mongo3.bender.MongoObjectIdUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.reminders.logic.flight.airport.Airports;
import ru.yandex.reminders.mongodb.DateTimeZoneMarshaller;
import ru.yandex.reminders.mongodb.DateTimeZoneUnmarshaller;
import ru.yandex.reminders.util.HostnameUtils;
import ru.yandex.reminders.util.ReadJsonByBenderResponseHandler;

public class RaspClient {

    private static final BenderMapper mapper = new BenderMapper(
            BenderConfiguration.cons(
                    MembersToBind.WITH_ANNOTATIONS, false,
                    CustomMarshallerUnmarshallerFactoryBuilder.cons()
                            .add(DateTimeZone.class, new DateTimeZoneMarshaller(), new DateTimeZoneUnmarshaller())
                            .add(ObjectId.class, new MongoObjectIdMarshaller(), new MongoObjectIdUnmarshaller())
                            .build()));

    private final String host;
    private final Timeout timeout;

    public RaspClient(String host, Timeout timeout) {
        HostnameUtils.validateHostOrHostPort(host);
        this.host = host;
        this.timeout = timeout;
    }

    public Airports getAirports() {
        return ApacheHttpClientUtils.execute(
                new HttpGet("http://" + host + "/export/airports/"),
                new ReadJsonByBenderResponseHandler<>(mapper.createParser(Airports.class)),
                timeout);
    }
}
