package ru.yandex.reminders.logic.flight.rasp;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.yandex.misc.io.http.Timeout;

@Configuration
public class RaspClientContextConfiguration {

    @Bean
    public RaspClient raspClient(
            @Value("${rasp.host}") String host,
            @Value("${rasp.timeout.secs}") int timeoutSecs) {
        return new RaspClient(host, Timeout.seconds(timeoutSecs));
    }
}
