package ru.yandex.reminders.logic.flight.shift;

import org.bson.types.ObjectId;
import org.joda.time.Instant;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.reminders.logic.reminder.Channel;
import ru.yandex.reminders.logic.reminder.SendResultStatus;

@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class FlightShiftSendResult {
    @MongoId
    private final ObjectId id;
    private final ObjectId flightShiftId;
    private final PassportUid uid;

    private final Instant sendTs;
    private final Channel channel;

    private final SendResultStatus status;
    private final Option<String> msgId;
    private final Option<String> fail;

    private final Instant processTs;

    private FlightShiftSendResult(
            ObjectId flightShiftId, PassportUid uid, Instant sendTs, Channel channel,
            SendResultStatus status, Option<String> msgId, Option<String> fail, Instant processTs) {
        this.id = ObjectId.get();
        this.flightShiftId = flightShiftId;
        this.uid = uid;
        this.channel = channel;
        this.sendTs = sendTs;
        this.status = status;
        this.msgId = msgId;
        this.fail = fail;
        this.processTs = processTs;
    }

    public static FlightShiftSendResult sent(
            ObjectId flightShiftId, PassportUid uid, Instant remindTs, Channel channel, Option<String> msgId, Instant now) {
        return new FlightShiftSendResult(
                flightShiftId, uid, remindTs, channel,
                SendResultStatus.SENT, msgId, Option.empty(), now);
    }

    public static FlightShiftSendResult failed(
            ObjectId flightShiftId, PassportUid uid, Instant remindTs, Channel channel, String failureReason, Instant now) {
        return new FlightShiftSendResult(
                flightShiftId, uid, remindTs, channel,
                SendResultStatus.FAILED, Option.empty(), Option.some(failureReason), now);
    }

    public ObjectId getId() {
        return id;
    }

    public ObjectId getFlightShiftId() {
        return flightShiftId;
    }

    public PassportUid getUid() {
        return uid;
    }

    public Channel getChannel() {
        return channel;
    }

    public SendResultStatus getStatus() {
        return status;
    }

    public Option<String> getMsgId() {
        return msgId;
    }

    public Option<String> getFail() {
        return fail;
    }

    public Instant getSendTs() {
        return sendTs;
    }

    public Instant getProcessTs() {
        return processTs;
    }
}
