package ru.yandex.reminders.logic.flight.shift;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import org.bson.types.ObjectId;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.commune.mongo3.schema.IndexInfo;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.reminders.mongodb.AbstractMdao;

public class FlightShiftSendResultMdao extends AbstractMdao<ObjectId, FlightShiftSendResult> {

    public FlightShiftSendResultMdao(MongoDatabase remindersDb) {
        super(remindersDb, "flightShiftSendResult", FlightShiftSendResult.class);
    }

    @Override
    public ListF<IndexInfo> getIndexes() {
        return Cf.list(new IndexInfo().key("flightShiftId", 1).key("uid", 1));
    }

    public void save(FlightShiftSendResult result) {
        collectionX.insertOne(result);
    }

    public Option<FlightShiftSendResult> find(ObjectId id) {
        return collectionX.findById(id);
    }

    public SetF<PassportUid> findUids(ObjectId flightShiftId) {
        return collectionX.find(
                Filters.eq("flightShiftId", flightShiftId),
                Projections.include("uid"),
                doc -> new PassportUid(doc.get("uid").asNumber().longValue())
        ).unique();
    }

}
