package ru.yandex.reminders.logic.flight.shift;

import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class FlightShiftSendStat {

    private final int eventsTotal;
    private final int eventsForSending;
    private final int remindersForRescheduling;
    private int sent = 0;
    private int sentOk = 0;
    private int sentFail = 0;
    private int sentDisabled = 0;
    private int sentTryAgain = 0;
    private int remindersRescheduled = 0;
    private int remindersNotRescheduled = 0;
    private int exception = 0;

    public FlightShiftSendStat(int eventsTotal, int eventsForSending, int remindersForRescheduling) {
        this.eventsTotal = eventsTotal;
        this.eventsForSending = eventsForSending;
        this.remindersForRescheduling = remindersForRescheduling;
    }

    public void incSentOk() {
        this.sent++;
        this.sentOk++;
    }

    public void incSentFail() {
        this.sent++;
        this.sentFail++;
    }

    public void incSentDisabled() {
        this.sentDisabled++;
    }

    public void incSentTryAgain() {
        this.sent++;
        this.sentTryAgain++;
    }

    public boolean isTryAgain() {
        return sentTryAgain > 0;
    }

    public void incRemindersRescheduled() {
        this.remindersRescheduled++;
    }

    public void incRemindersNotRescheduled() {
        this.remindersNotRescheduled++;
    }

    public void incException() {
        this.exception++;
    }

    public boolean isException() {
        return exception > 0;
    }
}
