package ru.yandex.reminders.logic.flight.shift;

import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

public class FlightShiftSentInfo {

    public static FlightShiftSentInfo sent(FlightShiftSendStat sendStat) {
        return new Sent(sendStat);
    }

    public static FlightShiftSentInfo failed(String reason) {
        return new Failed(reason);
    }

    public boolean isTryAgain() {
        return false;
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    private static class Sent extends FlightShiftSentInfo {
        private final String status = "sent";
        @BenderFlatten
        private final FlightShiftSendStat sendStat;

        public Sent(FlightShiftSendStat sendStat) {
            this.sendStat = sendStat;
        }

        @Override
        public boolean isTryAgain() {
            return sendStat.isTryAgain() || sendStat.isException();
        }
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    private static class Failed extends FlightShiftSentInfo {
        private final String status = "failed";
        private final String reason;

        public Failed(String reason) {
            this.reason = reason;
        }
    }

}
