package ru.yandex.reminders.logic.panel;

import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.reminders.logic.flight.FlightCity;
import ru.yandex.reminders.logic.flight.FlightEventMeta;
import ru.yandex.reminders.logic.flight.FlightItem;

@BenderBindAllFields
public class Flight {
    private final String flightNumber;

    private final Option<FlightItem> airline;

    private final FlightCity departureCity;
    private final Option<FlightItem> departureAirport;
    private final LocalDateTime departureTime;

    private final FlightCity arrivalCity;
    private final Option<FlightItem> arrivalAirport;
    private final Option<LocalDateTime> arrivalTime;

    private final Option<String> checkInLink;

    public Flight(FlightEventMeta flight) {
        this.flightNumber = flight.getFlightNumber();
        this.airline = flight.getAirline();
        this.departureCity = flight.getDepartureCity();
        this.departureAirport = flight.getDepartureAirport();
        this.departureTime = flight.getDepartureLocalDateTime();
        this.arrivalCity = flight.getArrivalCity();
        this.arrivalAirport = flight.getArrivalAirport();
        this.arrivalTime = flight.getArrivalDateTime().map(DateTime::toLocalDateTime);
        this.checkInLink = flight.getCheckInLink();
    }
}
