package ru.yandex.reminders.logic.panel;

import org.joda.time.LocalDateTime;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

import java.util.Optional;

@BenderBindAllFields
public class Hotel {
    private final String domain;
    private final String reservationNumber;
    private final String hotel;

    private final LocalDateTime checkinTime;
    private final LocalDateTime checkoutTime;
    private final Optional<LocalDateTime> cancellationDueTime;

    private final Optional<String> address;
    private final Optional<GeoObject> city;
    private final Optional<GeoObject> country;

    private final Optional<Integer> numNights;
    private final Optional<Integer> numPersons;
    private final Optional<String> price;
    private final Optional<String> editLink;

    public Hotel(
            String domain, String reservationNumber, String hotel,
            LocalDateTime checkinTime, LocalDateTime checkoutTime, Optional<LocalDateTime> cancellationDueTime,
            Optional<String> address,
            Optional<String> cityName, Optional<Integer> cityGeoId,
            Optional<String> countryName, Optional<Integer> countryGeoId,
            Optional<Integer> numNights, Optional<Integer> numPersons,
            Optional<String> price, Optional<String> editLink) {
        this.domain = domain;
        this.reservationNumber = reservationNumber;
        this.hotel = hotel;
        this.checkinTime = checkinTime;
        this.checkoutTime = checkoutTime;
        this.cancellationDueTime = cancellationDueTime;
        this.address = address;
        this.city = GeoObject.optional(cityName, cityGeoId);
        this.country = GeoObject.optional(countryName, countryGeoId);
        this.numNights = numNights;
        this.numPersons = numPersons;
        this.price = price;
        this.editLink = editLink;
    }

    @BenderBindAllFields
    public static class GeoObject {
        private final Optional<String> name;
        private final Optional<Integer> geoId;

        public GeoObject(Optional<String> name, Optional<Integer> geoId) {
            this.name = name;
            this.geoId = geoId;
        }

        public static Optional<GeoObject> optional(Optional<String> name, Optional<Integer> geoId) {
            return !name.isPresent() && !geoId.isPresent() ? Optional.empty() : Optional.of(new GeoObject(name, geoId));
        }
    }
}
