package ru.yandex.reminders.logic.panel;

import org.joda.time.LocalDateTime;

import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.serialize.simpleType.LocalDateTimeMarshaller;

/**
 * @author dbrylev
 */
public class PanelBender {
    public static final BenderMapper mapper = new BenderMapper(getConfiguration());

    public static BenderConfiguration getConfiguration() {
        return BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryBuilder.cons()
                        .add(LocalDateTime.class, new LocalDateTimeMarshaller())
                        .build());
    }
}
