package ru.yandex.reminders.logic.panel;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.misc.io.http.Timeout;

/**
 * @author dbrylev
 */
@Configuration
public class PanelManagerContextConfiguration {

    @Bean
    public PanelPushClient panelApiClient(
            @Value("${panel.push.host}") String host,
            @Value("${panel.push.token}") String token,
            @Value("${panel.push.timeout.secs}") int timeoutSecs)
    {
        return new PanelPushClient(host, token, Timeout.seconds(timeoutSecs));
    }

    @Bean
    public PanelManager panelManager(PanelPushClient client) {
        return new PanelManager(client);
    }

}
