package ru.yandex.reminders.logic.panel;

import org.apache.http.impl.client.CloseableHttpClient;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClient4;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.client.HttpClient;
import ru.yandex.misc.io.http.client.entity.StringEntity;
import ru.yandex.reminders.util.HostnameUtils;

import javax.annotation.PreDestroy;

public class PanelPushClient {

    private static final String USER_AGENT = "Yandex.Reminders";
    private final HttpClient httpClient;
    private final String host;
    private final String token;

    public PanelPushClient(String host, String token, Timeout timeout) {
        this(ApacheHttpClient4.wrap((CloseableHttpClient) (EnvironmentType.PRODUCTION.isActive()
                ? ApacheHttpClientUtils.multiThreadedHttpsClient(timeout, 30, USER_AGENT)
                : ApacheHttpClientUtils.trustAllMultiThreadedHttpsClient(timeout, 30, 30, USER_AGENT))), host, token);
    }

    PanelPushClient(HttpClient httpClient, String host, String token) {
        HostnameUtils.validateHostOrHostPort(host);
        this.httpClient = httpClient;
        this.host = host;
        this.token = token;
    }

    public void push(PassportUid uid, String eventType, String message) {
        String url = UriBuilder.cons("https://" + host).appendPath("/v1/send")
                .addParam("stoken", token)
                .addParam("uid", uid)
                .addParam("event", eventType).toUrl();

        httpClient.post(url, new StringEntity(message, Option.some("utf-8")));
    }

    @PreDestroy
    public void close() {
        httpClient.stop();
    }

}
