package ru.yandex.reminders.logic.panel.old;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultToString;

/**
 * Transport object for http://wiki.yandex-team.ru/Vertikali/Pomoshnik/backend/api/cases/note/io-api#dobavleniezametki
 * excluding <code>data</code> field -- this field will be of special type for each subclass.
 */
@Bendable
@BenderMembersToBind(value = MembersToBind.ALL_FIELDS)
public class BasicNote extends DefaultToString {

    private final String type;
    private final Option<Long> timestamp;

    @BenderPart(name = "block-title", strictName = true)
    private final Option<String> blockTitle;
    @BenderPart(name = "block-icon", strictName = true)
    private final Option<String> blockIconUrl;

    @BenderPart(name = "redirect-url", strictName = true)
    private final Option<String> redirectUrl;

    private final Option<NoteDesign> design;
    private final Option<NoteAction> action;

    public BasicNote(String type, Option<Long> timestamp, Option<String> blockTitle, Option<String> blockIconUrl,
                     Option<String> redirectUrl, Option<NoteDesign> design, Option<NoteAction> action) {
        this.type = type;
        this.timestamp = timestamp;
        this.blockTitle = blockTitle;
        this.blockIconUrl = blockIconUrl;
        this.redirectUrl = redirectUrl;
        this.design = design;
        this.action = action;
    }

}
