package ru.yandex.reminders.logic.panel.old;

import lombok.val;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.reminders.logic.event.Event;
import ru.yandex.reminders.logic.flight.FlightEventMeta;
import ru.yandex.reminders.logic.flight.FlightItem;
import ru.yandex.reminders.logic.panel.old.schema.flight.Airport;
import ru.yandex.reminders.logic.panel.old.schema.flight.Flight;
import ru.yandex.reminders.logic.panel.old.schema.flight.FlightReservation;
import ru.yandex.reminders.logic.panel.old.schema.flight.PostalAddress;
import ru.yandex.reminders.logic.reminder.Reminder;

public class NoteDataConverter {

    public static FlightNote toFlightNote(FlightEventMeta flightEventMeta, long timestamp) {
        val noteAction = Option.when(
                flightEventMeta.getCheckInLink().isPresent() || flightEventMeta.getAeroexpressLink().isDefined(),
                new NoteAction("simple",
                        flightEventMeta.getCheckInLink().map(toNoteActionButtonF("Регистрация на рейс")), // TODO: i18n?
                        flightEventMeta.getAeroexpressLink().map(toNoteActionLinkF("Аэроэкспресс")))); // TODO: i18n?

        val flightReservation = new FlightReservation(
                Option.empty(),
                new Flight(
                        Option.empty(),
                        Option.of(flightEventMeta.getFlightNumber()),
                        Option.of(new Airport(
                                flightEventMeta.getDepartureAirport().flatMapO(FlightItem::getName),
                                new PostalAddress(
                                        Option.empty(), Option.of(flightEventMeta.getDepartureCity().getName())),
                                Option.empty())),
                        Option.of(flightEventMeta.getDepartureDateTime()),
                        Option.of(new Airport(
                                Option.empty(),
                                new PostalAddress(Option.empty(), Option.of(flightEventMeta.getArrivalCity().getName())),
                                Option.empty())),
                        Option.empty()));

        return new FlightNote(
                "schema.org",
                Option.of(timestamp),
                "https://mail.yandex.ru/message?ids=" + flightEventMeta.getMid(),
                Option.of(new NoteDesign("#e24767")),
                noteAction,
                flightReservation
        );
    }

    public static UniversalNote toUniversalNote(Event event, Reminder reminder, long timestamp) {
        return new UniversalNote(
                "default",
                Option.of(timestamp),
                reminder.getUrl(),
                Option.empty(),
                Option.empty(),
                reminder.getSubject().orElse(event.getName()),
                reminder.getMessage().orElse(event.getDescription())
        );
    }

    private static Function<String, NoteActionButton> toNoteActionButtonF(final String label) {
        return s -> new NoteActionButton(label, s);
    }

    private static Function<String, NoteActionLink> toNoteActionLinkF(final String label) {
        return s -> new NoteActionLink(label, s);
    }

}
