package ru.yandex.reminders.logic.panel.old;

import org.joda.time.DateTime;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.commune.json.bender.JsonValueMarshaller;
import ru.yandex.commune.json.bender.JsonValueUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.parse.simpleType.SimpleTypeUnmarshallerSupport;
import ru.yandex.misc.bender.serialize.simpleType.StringValueMarshaller;
import ru.yandex.reminders.api.DateTimeConverters;

public class PanelBender {

    public static final BenderMapper mapper = new BenderMapper(getConfiguration());

    public static BenderConfiguration getConfiguration() {
        return BenderConfiguration.cons(
                MembersToBind.WITH_ANNOTATIONS, false,
                CustomMarshallerUnmarshallerFactoryBuilder.cons()
                        .add(DateTime.class, new DateTimeMarshaller(), new DateTimeUnmarshaller())
                        .add(JsonValue.class, new JsonValueMarshaller(), new JsonValueUnmarshaller())
                        .build());
    }

    private static class DateTimeMarshaller extends StringValueMarshaller {
        protected String toStringValue(Object o) {
            return DateTimeConverters.dateTimeWithTzConverter.toString((DateTime) o);
        }
    }

    private static class DateTimeUnmarshaller extends SimpleTypeUnmarshallerSupport {
        protected Object convert(String o) {
            return DateTimeConverters.dateTimeWithTzConverter.parse(o);
        }
    }
}
