package ru.yandex.reminders.logic.panel.old;

import org.bson.types.ObjectId;
import org.joda.time.Duration;
import org.joda.time.Instant;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.reminders.logic.event.Event;
import ru.yandex.reminders.logic.flight.FlightEventMeta;
import ru.yandex.reminders.logic.panel.old.client.PanelApiClient;
import ru.yandex.reminders.logic.panel.old.client.PanelApiClientException;
import ru.yandex.reminders.logic.reminder.Reminder;
import ru.yandex.reminders.logic.reminder.SendStatus;

public class PanelManager {

    private static final Logger logger = LoggerFactory.getLogger(PanelManager.class);

    private static final String SECURE_KEY = "EHGjan4fzQRRSsj9NudU_calendar_20131122";

    private final PanelApiClient panelApiClient;
    private final BenderMapper benderMapper;

    public PanelManager(PanelApiClient panelApiClient, BenderMapper benderMapper) {
        this.panelApiClient = panelApiClient;
        this.benderMapper = benderMapper;
    }

    private SendStatus addNote(Event event, BasicNote note, Instant expires) {
        byte[] bytes = benderMapper.serializeJson(note);
        try {
            String noteId = generateNoteId();
            panelApiClient.addNote(event.getUid(), event.getClientId(), noteId, SECURE_KEY, expires, bytes);
            return new SendStatus.Sent(noteId, Option.none());
        } catch (PanelApiClientException e) {
            logger.error("adding panel note for eventId={} failed, error={}", event.getId(), e);
            return e.isRetriable()
                    ? new SendStatus.TryAgain(e.getMessage(), Option.none())
                    : new SendStatus.Failed(e.getMessage(), Option.none());
        }
    }

    private String generateNoteId() {
        return ObjectId.get().toString();
    }

}
