package ru.yandex.reminders.logic.panel.old;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.reminders.logic.panel.old.client.PanelApiClient;

@Configuration
public class PanelManagerContextConfiguration {

    @Bean
    public PanelApiClient panelApiClient(
            @Value("${panel.api.host}") String panelApiUrlHost,
            @Value("${panel.api.timeout.secs}") int timeoutSecs)
    {
        return new PanelApiClient(panelApiUrlHost, Timeout.seconds(timeoutSecs));
    }

    @Bean
    public PanelManager panelManager(PanelApiClient panelApiClient) {
        return new PanelManager(panelApiClient, PanelBender.mapper);
    }

}
