package ru.yandex.reminders.logic.panel.old;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

/**
 * @author Eugene Voytitsky
 */
@Bendable
@BenderMembersToBind(value = MembersToBind.ALL_FIELDS)
public class UniversalNote extends BasicNote {

    private final Option<JsonValue> data;

    public UniversalNote(String type, Option<Long> timestamp, Option<String> redirectUrl,
            Option<NoteDesign> design, Option<NoteAction> action, Option<JsonObject> data)
    {
        super(type, timestamp, Option.<String>none(), Option.<String>none(), redirectUrl, design, action);
        this.data = data.uncheckedCast();
    }

    public UniversalNote(String type, Option<Long> timestamp, Option<String> redirectUrl,
            Option<NoteDesign> design, Option<NoteAction> action, Option<String> subject, Option<String> message)
    {
        this(type, timestamp, redirectUrl, design, action, Option.of(new JsonObject(Cf.toMap(
                Tuple2List.<String, JsonValue>tuple2List()
                        .plus(Cf.list("subject").zip(subject.map(JsonString::valueOf)))
                        .plus(Cf.list("message").zip(message.map(JsonString::valueOf)))))));
    }
}
