package ru.yandex.reminders.logic.panel.old.client;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.thread.WhatThreadDoes;
import ru.yandex.reminders.util.HostnameUtils;

import javax.annotation.PreDestroy;
import java.nio.charset.Charset;

public class PanelApiClient {

    private static final Logger logger = LoggerFactory.getLogger(PanelApiClient.class);

    private static final ContentType APPLICATION_JSON_WITH_UTF8 = ContentType.create(
            ContentType.APPLICATION_JSON.getMimeType(), Charset.forName("UTF-8"));

    private final HttpClient httpClient;
    private final String panelApiUrlHost;

    public PanelApiClient(String panelApiUrlHost, Timeout timeout) {
        this(panelApiUrlHost, ApacheHttpClientUtils.multiThreadedClient(timeout, 50));
    }

    PanelApiClient(String panelApiUrlHost, HttpClient httpClient) {
        HostnameUtils.validateHostOrHostPort(panelApiUrlHost);
        this.panelApiUrlHost = panelApiUrlHost;
        this.httpClient = httpClient;
    }

    public static String formatRfc1123(ReadableInstant instant) {
        return DateUtils.formatDate(instant.toInstant().toDate());
    }

    @PreDestroy
    public void close() {
        ApacheHttpClientUtils.stopQuietly(httpClient);
    }

    public void addNote(PassportUid uid, String service, String id, String secureKey, Instant expires, byte[] body) {
        String url = String.format(
                "http://%s/api/1.x/case/note/uid/%d/service/%s/item/%s",
                panelApiUrlHost, uid.getUid(), UrlUtils.urlEncode(service), id);

        HttpPut request = new HttpPut(url);
        request.setHeader("Secure-Key", secureKey);
        request.setHeader("Expires", formatRfc1123(expires));
        request.setHeader("Content-Type", APPLICATION_JSON_WITH_UTF8.toString());
        request.setEntity(new ByteArrayEntity(body, APPLICATION_JSON_WITH_UTF8));

        execute(request, "adding panel note for uid=" + uid);
    }

    private void execute(HttpUriRequest request, String info) {
        WhatThreadDoes.Handle h = WhatThreadDoes.push(info);
        try {
            int statusCode;
            try {
                HttpResponse httpResponse = ApacheHttpClientUtils.execute(request, httpClient, (response) -> response);

                statusCode = httpResponse.getStatusLine().getStatusCode();
            } catch (RuntimeException e) {
                throw new PanelApiClientException(e, true);
            }
            if (HttpStatus.is2xx(statusCode)) {
                logger.info("{} completed successfully, status code={}", info, statusCode);
            } else {
                throw new PanelApiClientException(
                        "request wasn't completed successfully, status code=" + statusCode,
                        !HttpStatus.is4xx(statusCode));
            }
        } finally {
            h.popSafely();
        }
    }

}
