package ru.yandex.reminders.logic.panel.old.schema.flight;

import org.joda.time.DateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

/**
 * The very limited version of
 * https://developers.google.com/gmail/actions/reference/types/Flight
 *
 * @author Eugene Voytitsky
 */
@Bendable
@BenderMembersToBind(value = MembersToBind.ALL_FIELDS)
public class Flight extends Thing {

    private final Option<String> flightNumber;
    private final Option<Airport> departureAirport;
    private final Option<DateTime> departureTime;
    private final Option<Airport> arrivalAirport;
    private final Option<DateTime> arrivalTime;

    public Flight(Option<String> name, Option<String> flightNumber,
            Option<Airport> departureAirport, Option<DateTime> departureTime,
            Option<Airport> arrivalAirport, Option<DateTime> arrivalTime)
    {
        super(name);
        this.flightNumber = flightNumber;
        this.departureAirport = departureAirport;
        this.departureTime = departureTime;
        this.arrivalAirport = arrivalAirport;
        this.arrivalTime = arrivalTime;
    }
}
