package ru.yandex.reminders.logic.reminder;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

public enum Channel implements IntEnum {
    SMS(0),
    EMAIL(1),
    PANEL(2),
    CALLBACK(3),
    CLOUD_API(4),
    SUP(5),
    XIVA(6),
    ;

    public static IntEnumResolver<Channel> R = IntEnumResolver.r(Channel.class);

    private final int value;

    Channel(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }
}
