package ru.yandex.reminders.logic.reminder;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;
import ru.yandex.reminders.logic.event.SpecialClientIds;

public enum EventType implements IntEnum {
    FLIGHT(0, SpecialClientIds.FLIGHT),
    TV_PROGRAM(1, SpecialClientIds.TV),
    ;

    private static final MapF<String, EventType> CLIENT_ID_TO_EVENT_TYPE =
            Cf.list(EventType.values()).toMapMappingToKey(getClientIdF());
    public static IntEnumResolver<EventType> R = IntEnumResolver.r(EventType.class);
    private final int value;
    private final String clientId;

    EventType(int value, String clientId) {
        this.value = value;
        this.clientId = clientId;
    }

    public static Function<EventType, String> getClientIdF() {
        return EventType::getClientId;
    }

    @Override
    public int value() {
        return value;
    }

    public String getClientId() {
        return clientId;
    }
}
