package ru.yandex.reminders.logic.reminder;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderWrapper;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.Validate;

/**
 * @author dbrylev
 */
@Bendable
@BenderWrapper
public class PhoneNumber extends DefaultObject {
    private final String phone;

    public PhoneNumber(String phone) {
        Validate.equals('+', phone.charAt(0), "Unexpected phone format");
        Validate.some(Cf.Long.parseSafe(phone.substring(1)), "Unexpected phone format");

        this.phone = phone;
    }

    public static PhoneNumber number(long number) {
        return new PhoneNumber("+" + number);
    }

    public long getNumber() {
        return Cf.Long.parse(phone.substring(1));
    }

    public String getPhone() {
        return phone;
    }

    public static Function<Long, PhoneNumber> numberF() {
        return new Function<Long, PhoneNumber>() {
            public PhoneNumber apply(Long number) {
                return number(number);
            }
        };
    }

    public static Function<String, PhoneNumber> phoneF() {
        return new Function<String, PhoneNumber>() {
            public PhoneNumber apply(String s) {
                return new PhoneNumber(s);
            }
        };
    }

    public static Function<PhoneNumber, Long> getNumberF() {
        return new Function<PhoneNumber, Long>() {
            public Long apply(PhoneNumber phone) {
                return phone.getNumber();
            }
        };
    }
}
