package ru.yandex.reminders.logic.reminder;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.reminders.api.unistat.UnistatConfiguration;
import ru.yandex.reminders.boot.RemindersMongoContextConfiguration;
import ru.yandex.reminders.logic.flight.FlightReminderManager;
import ru.yandex.reminders.logic.flight.shift.FlightShiftSendManager;
import ru.yandex.reminders.logic.sending.SendingContextConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import({
    RemindersMongoContextConfiguration.class,
    SendingContextConfiguration.class,
    UnistatConfiguration.class,
})
public class ReminderContextConfiguration {

    @Bean
    public ReminderSendManager reminderSendManager() {
        return new ReminderSendManager();
    }

    @Bean
    public FlightShiftSendManager flightShiftSendManager() {
        return new FlightShiftSendManager();
    }
}
