package ru.yandex.reminders.logic.reminder;

import org.joda.time.LocalDate;

import ru.yandex.bolts.function.Function;

/**
 * @author dbrylev
 */
public class SendDailyStat {
    private final LocalDate date;
    private final int sent;
    private final int failed;

    public SendDailyStat(LocalDate date, int sent, int failed) {
        this.date = date;
        this.sent = sent;
        this.failed = failed;
    }

    public LocalDate getDate() {
        return date;
    }

    public int getSent() {
        return sent;
    }

    public int getFailed() {
        return failed;
    }

    public int getTotal() {
        return getSent() + getFailed();
    }

    public static Function<SendDailyStat, LocalDate> getDateF() {
        return new Function<SendDailyStat, LocalDate>() {
            public LocalDate apply(SendDailyStat s) {
                return s.getDate();
            }
        };
    }

    public static Function<SendDailyStat, Integer> getSentF() {
        return new Function<SendDailyStat, Integer>() {
            public Integer apply(SendDailyStat s) {
                return s.getSent();
            }
        };
    }

    public static Function<SendDailyStat, Integer> getFailedF() {
        return new Function<SendDailyStat, Integer>() {
            public Integer apply(SendDailyStat s) {
                return s.getFailed();
            }
        };
    }

    public static Function<SendDailyStat, Integer> getTotalF() {
        return new Function<SendDailyStat, Integer>() {
            public Integer apply(SendDailyStat s) {
                return s.getTotal();
            }
        };
    }
}
