package ru.yandex.reminders.logic.reminder;

import org.bson.types.ObjectId;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderFlatten;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.reminders.logic.event.EventId;

/**
 * @author dbrylev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class SendResult {
    @MongoId
    private final ObjectId id;
    @BenderFlatten
    private final EventId eventId;
    private final ObjectId reminderId;

    private final Instant remindTs;
    private final Channel channel;

    private final SendResultStatus status;
    private final Option<String> msgId;
    private final Option<String> fail;

    private final Instant processTs;

    private SendResult(
            EventId eventId, ObjectId reminderId, Instant remindTs, Channel channel,
            SendResultStatus status, Option<String> msgId, Option<String> fail, Instant processTs)
    {
        this.id = ObjectId.get();
        this.eventId = eventId;
        this.reminderId = reminderId;
        this.channel = channel;
        this.remindTs = remindTs;
        this.status = status;
        this.msgId = msgId;
        this.fail = fail;
        this.processTs = processTs;
    }

    public static SendResult sent(
            EventId eventId, ObjectId reminderId, Instant remindTs, Channel channel, Option<String> msgId, Instant now)
    {
        return new SendResult(
                eventId, reminderId, remindTs, channel,
                SendResultStatus.SENT, msgId, Option.<String>none(), now);
    }

    public static SendResult failed(
            EventId eventId, ObjectId reminderId, Instant remindTs, Channel channel, String failureReason, Instant now)
    {
        return new SendResult(
                eventId, reminderId, remindTs, channel,
                SendResultStatus.FAILED, Option.<String>none(), Option.some(failureReason), now);
    }

    public EventId getEventId() {
        return eventId;
    }

    public ObjectId getReminderId() {
        return reminderId;
    }

    public Channel getChannel() {
        return channel;
    }

    public SendResultStatus getStatus() {
        return status;
    }

    public Option<String> getMsgId() {
        return msgId;
    }

    public Option<String> getFail() {
        return fail;
    }

    public Instant getRemindTs() {
        return remindTs;
    }

    public Instant getProcessTs() {
        return processTs;
    }
}
