package ru.yandex.reminders.logic.sending;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.mail.*;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.io.ClassPathResourceInputStreamSource;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.xml.XmlUtils;
import ru.yandex.misc.xml.jdom.JdomUtils;
import ru.yandex.misc.xml.saxon.SaxonUtils;
import ru.yandex.reminders.logic.sending.emails.EmailXsl;

import javax.activation.FileTypeMap;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;

public class MailMessageCreator {

    private static final BenderMapper benderMapper = new BenderMapper(BenderConfiguration.defaultConfiguration());

    public static MailMessage create(Object object) {
        Validate.isTrue(object.getClass().isAnnotationPresent(EmailXsl.class), "not annotated with @EmailXsl");

        Document xml = JdomUtils.I.read(InputStreamSourceUtils.bytes(benderMapper.serializeXml(object)));

        String xslName = object.getClass().getAnnotation(EmailXsl.class).value();
        InputStreamSource xslIss = new ClassPathResourceInputStreamSource(EmailXsl.class, xslName);
        Transformer transformer = SaxonUtils.newTransformer(xslIss);

        Source source = new JDOMSource(xml);
        JDOMResult result = new JDOMResult();
        try {
            transformer.transform(source, result);
        } catch (Exception e) {
            throw XmlUtils.translate(e);
        }
        Document document = result.getDocument();
        String htmlBody = JdomUtils.I.writeElementToString(
                document.getRootElement().getChild("html-body").getChild("html"));

        ListF<Element> imageElements = Cf.x(document.getRootElement().getChildren("image"));
        ListF<BodyPart> images = Cf.arrayList();

        for (Element imageElement : imageElements) {
            String cid = imageElement.getAttribute("cid").getValue();
            String src = imageElement.getAttribute("src").getValue();

            String contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(src);
            InputStreamSource contentSource = new ClassPathResourceInputStreamSource(EmailXsl.class, src);

            images.add(BodyPart.empty()
                    .withContent(new DefaultContent(contentSource.readBytes()))
                    .withHeader("Content-ID", "<" + cid + ">")
                    .withContentType(contentType));
        }

        MailMessageHeader subject = new MailMessageHeader(HeaderNames.SUBJECT,
                document.getRootElement().getChildText("subject"));
        Multipart body = new Multipart(
                Cf.list(BodyPart.create(htmlBody, ContentType.TEXT_HTML_UTF8)).plus(images));

        return new MailMessage(Cf.list(subject), body);
    }
}
