package ru.yandex.reminders.logic.sending;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.commune.mail.javamail.JavamailMailSender;
import ru.yandex.commune.mail.send.MailSender;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.sms.PassportSmsService;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.reminders.logic.callback.CallbackManagerContextConfiguration;
import ru.yandex.reminders.logic.cloudApi.CloudApiContextConfiguration;
import ru.yandex.reminders.logic.flight.FlightReminderManager;
import ru.yandex.reminders.logic.panel.PanelManagerContextConfiguration;
import ru.yandex.reminders.logic.sup.SupPushContextConfiguration;
import ru.yandex.reminders.logic.tv.TvReminderManager;
import ru.yandex.reminders.tvm.TvmContextConfiguration;

@Configuration
@Import({
        TvmContextConfiguration.class,
        PanelManagerContextConfiguration.class,
        CallbackManagerContextConfiguration.class,
        CloudApiContextConfiguration.class,
        SupPushContextConfiguration.class,
})
public class SendingContextConfiguration {
    @Bean
    public SmsSender smsSender() {
        return new SmsSender();
    }

    @Bean
    public PassportSmsService passportSmsService() {
        return new PassportSmsService();
    }

    @Bean
    public Blackbox2 blackbox(@Value("${blackbox.url}") String url) {
        return Blackbox2.cons(url);
    }

    @Bean
    public MailSender mailSender() {
        return new JavamailMailSender(PropertiesHolder.properties());
    }

    @Bean
    public FlightReminderManager flightReminderManager() {
        return new FlightReminderManager();
    }

    @Bean
    public TvReminderManager tvReminderManager() {
        return new TvReminderManager();
    }
}
