package ru.yandex.reminders.logic.sending;

import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.sms.PassportSmsService;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.reminders.logic.reminder.PhoneNumber;

public class SmsSender {
    private static final Logger logger = LoggerFactory.getLogger(SmsSender.class);

    @Value("${sms.passport.sender}")
    private String smsPassportSender;
    @Autowired
    private PassportSmsService passportSmsService;

    public String sendToUser(PassportUid uid, Option<PhoneNumber> phone, String message, String identity) {
        return phone.isDefined()
                ? sendToUserPhone(uid, phone.get(), message, identity)
                : sendToUid(uid, message, identity);
    }

    private String sendToUid(PassportUid uid, String message, String identity) {
        logger.info("Sending sms to user [{}], message [{}]", uid, message);
        return passportSmsService.sendToUid(uid.getUid(), message, smsPassportSender, PassportSmsService.getDefaultTimeout(), Optional.of(identity));
    }

    private String sendToUserPhone(PassportUid uid, PhoneNumber phone, String message, String identity) {
        logger.info("Sending sms to user phone [{}, {}], message [{}]", uid, phone.getPhone(), message);
        return passportSmsService.sendToUidNumber(uid.getUid(), phone.getPhone(), message, smsPassportSender,
                PassportSmsService.getDefaultTimeout(), Optional.of(identity));
    }
}
