package ru.yandex.reminders.logic.sending.emails;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

@EmailXsl("event-email.xsl")
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class EventEmailInfo {
    private final String eventName;
    private final Option<String> eventDescription;

    private final Option<String> emailSubject;
    private final Option<String> senderName;

    private final Option<String> jsonData;

    public EventEmailInfo(
            String eventName, Option<String> eventDescription,
            Option<String> emailSubject, Option<String> senderName,
            Option<JsonObject> jsonData)
    {
        this.eventName = eventName;
        this.eventDescription = eventDescription;
        this.emailSubject = emailSubject;
        this.senderName = senderName;
        this.jsonData = jsonData.map(JsonValue::serialize);
    }
}
