package ru.yandex.reminders.logic.sending.emails;

import org.joda.time.LocalDateTime;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.reminders.i18n.Language;
import ru.yandex.reminders.i18n.Messages;
import ru.yandex.reminders.logic.flight.FlightEventMeta;
import ru.yandex.reminders.logic.flight.FlightItem;

/**
 * @author dbrylev
 */
@EmailXsl("flight-email.xsl")
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class FlightEmailInfo {
    private final String mid;
    private final String flightNumber;

    private final String departureCity;
    private final Option<String> departureAirport;
    private final LocalDateTime departureDateTime;

    private final String arrivalCity;
    private final Option<String> checkInLink;
    private final Option<String> aeroexpressLink;

    private final Option<String> lastSegmentFlightNumber;
    private final Option<LocalDateTime> lastSegmentDepartureDateTime;

    private final MapF<String, String> i18n;
    private final String yaDomain;

    public FlightEmailInfo(FlightEventMeta meta) {
        this(meta, meta.getLanguage());
    }

    public FlightEmailInfo(FlightEventMeta meta, Language lang) {
        this.mid = meta.getMid();
        this.flightNumber = meta.getFlightNumber();
        this.departureCity = meta.getDepartureCity().getName();
        this.departureAirport = meta.getDepartureAirport().flatMapO(FlightItem::getName);
        this.departureDateTime = meta.getDepartureDateTime().toLocalDateTime();
        this.arrivalCity = meta.getArrivalCity().getName();
        this.checkInLink = meta.getCheckInLink();
        this.aeroexpressLink = meta.getAeroexpressLink();
        this.lastSegmentFlightNumber = meta.getLastSegmentFlightNumber();
        this.lastSegmentDepartureDateTime = meta.getLastSegmentDepartureDateTime();
        this.i18n = Messages.M.getMessages(lang);
        this.yaDomain = meta.getYaDomainOrYandexRu();
    }
}
