package ru.yandex.reminders.logic.sending.emails;

import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.ObjectUtils;

import java.util.Optional;

@EmailXsl("rich-event-email.xsl")
@BenderBindAllFields
public class RichEventEmailInfo {
    private final String name;
    private final Optional<String> description;

    private final Optional<String> startDate;
    private final Optional<String> startTime;
    private final Optional<String> endDate;
    private final Optional<String> endTime;
    private final Optional<String> duration;

    private final Optional<String> url;
    private final Optional<String> imageUrl;

    private final Optional<String> emailSubject;
    private final Optional<String> senderName;
    private final Optional<String> senderUrl;

    private final Optional<String> jsonData;

    public RichEventEmailInfo(
            String name, Optional<String> description,
            Optional<LocalDate> startDate, Optional<LocalTime> startTime,
            Optional<LocalDate> endDate, Optional<LocalTime> endTime,
            Optional<Duration> duration, Optional<String> url, Optional<String> imageUrl,
            Optional<String> emailSubject,
            Optional<String> senderName, Optional<String> senderUrl, Optional<JsonObject> jsonData) {
        this.name = name;
        this.description = description;
        this.startDate = startDate.map(ObjectUtils::toString);
        this.startTime = startTime.map(ObjectUtils::toString);
        this.endDate = endDate.map(ObjectUtils::toString);
        this.endTime = endTime.map(ObjectUtils::toString);
        this.duration = duration.map(ObjectUtils::toString);
        this.url = url;
        this.imageUrl = imageUrl;
        this.emailSubject = emailSubject;
        this.senderName = senderName;
        this.senderUrl = senderUrl;
        this.jsonData = jsonData.map(JsonValue::serialize);
    }
}
