<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ya="urn:yandex-functions"
                exclude-result-prefixes="ya"
                version="2.0">

    <xsl:output method="xml" encoding="utf-8"/>

    <xsl:variable name="info" select="/event-email-info"/>

    <xsl:template match="/">
        <mail>
            <subject><xsl:apply-templates select="." mode="subject"/></subject>
            <html-body><xsl:apply-templates select="." mode="html-body"/></html-body>
        </mail>
    </xsl:template>

    <xsl:template match="/" mode="subject">
        <xsl:for-each select="$info/sender-name">
            <xsl:value-of select="concat('[', ., '] ')"/>
        </xsl:for-each>

        <xsl:value-of select="$info/email-subject[$info/email-subject]"/>
        <xsl:value-of select="$info/event-name[not($info/email-subject)]"/>
    </xsl:template>

    <xsl:template name="json-data">
        <xsl:if test="$info/json-data">
            <script type="application/ld+json">
                <xsl:value-of select="$info/json-data/text()" disable-output-escaping="yes"/>
            </script>
        </xsl:if>
    </xsl:template>

    <xsl:template match="/" mode="html-body">
        <html>
            <body>
                <xsl:call-template name="json-data"/>
                <!-- TODO: inline images using parts -->
                <table width="770" cellpadding="0" cellspacing="0" align="center" style="background-color: #f8f8f8; background-image: url('http://yandex.st/forgetmenot/email/bg-noise.png'); background-repeat: repeat; font-family: Arial, sans-serif; font-size: 14px;">
                    <tr>
                        <td style="padding-top: 60px; padding-right: 70px; padding-bottom: 60px; padding-left: 70px;">
                            <img src="http://yandex.st/lego/_/X31pO5JJJKEifJ7sfvuf3mGeD_8.png" alt="Яндекс" style="margin-left: 30px; margin-bottom: 15px;"/>
                            <table width="100%" cellpadding="0" cellspacing="0" align="center" style="border-color: #e6e6e6; border-width: 1px; border-style: solid; border-collapse: separate; background-color: #fff; padding-top: 40px; padding-right: 30px; padding-bottom: 40px; padding-left: 30px;">
                                <tr>
                                    <td style="padding-left: 30px;">
                                        <xsl:for-each select="$info/sender-name">
                                            <p style="font-family: Arial, sans-serif; font-size: 19px; margin-top: 10px; margin-bottom: 15px;">
                                                <xsl:value-of select="concat(., ' напоминает')"/>
                                            </p>
                                        </xsl:for-each>
                                        <p style="font-family: Arial, sans-serif; font-size: 14px; line-height: 17px; margin-top: 15px; margin-bottom: 15px;">
                                            <xsl:text>Не забудьте, у вас </xsl:text>
                                            <xsl:value-of select="$info/event-name"/>
                                        </p>
                                        <xsl:for-each select="$info/event-description">
                                            <p style="font-family: Arial, sans-serif; font-size: 14px; line-height: 17px; margin-top: 15px; margin-bottom: 15px;">
                                                <xsl:value-of select="."/>
                                            </p>
                                        </xsl:for-each>
                                    </td>
                                </tr>
                            </table>
                            <table width="100%" cellpadding="0" cellspacing="0" align="center">
                                <tr>
                                    <td style="padding-top: 12px; background-image: url('http://yandex.st/forgetmenot/email/shadow.png');"/>
                                </tr>
                                <!--tr>
                                    <td style="font-family: Arial, sans-serif; font-size: 12px; color: #888888; padding-right: 30px; padding-left: 30px;">Письмо сформировано автоматически, отвечать на него не нужно. Если вы хотите с нами связаться, пожалуйста, воспользуйтесь формой <a href="http://feedback2.yandex.ru/mail/" style="color:#888888;">обратной связи</a>.</td>
                                </tr-->
                            </table>
                        </td>
                    </tr>
                </table>
            </body>
        </html>
    </xsl:template>

</xsl:stylesheet>
