<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ya="urn:yandex-functions"
                exclude-result-prefixes="ya"
                version="2.0">

    <xsl:output method="xml" encoding="utf-8"/>

    <xsl:variable name="info" select="/flight-email-info"/>

    <xsl:template match="/">
        <mail>
            <subject><xsl:apply-templates select="." mode="subject"/></subject>
            <html-body><xsl:apply-templates select="." mode="html-body"/></html-body>
        </mail>
    </xsl:template>

    <xsl:template match="/" mode="subject">
        <xsl:value-of select="ya:i18n('flight.mail.subject', (
                $info/departure-city/text(), $info/arrival-city/text(), ya:format-dateTime($info/departure-date-time)))"/>
    </xsl:template>

    <xsl:template match="/" mode="html-body">
        <html>
            <body>
                <xsl:value-of select="ya:i18n('flight.mail.greeting')"/>
                <br/><br/>

                <xsl:value-of select="ya:i18n('flight.mail.points', ($info/departure-city/text(), $info/arrival-city/text()))"/>
                <br/>

                <xsl:value-of select="ya:i18n('flight.mail.trip', (
                        $info/flight-number/text(), ya:format-dateTime($info/departure-date-time)))"/>
                <br/>
                <xsl:if test="$info/last-segment-flight-number and $info/last-segment-departure-date-time">
                    <xsl:variable name="number" select="$info/last-segment-flight-number/text()"/>
                    <xsl:variable name="departure" select="$info/last-segment-departure-date-time"/>

                    <xsl:value-of select="ya:i18n('flight.mail.trip', ($number, ya:format-dateTime($departure)))"/>
                    <br/>
                </xsl:if>

                <xsl:if test="$info/departure-airport">
                    <xsl:value-of select="ya:i18n('flight.mail.airport', ($info/departure-airport))"/>
                    <br/>
                </xsl:if>

                <xsl:value-of select="ya:i18n('flight.mail.offset')"/>
                <br/><br/>

                <xsl:variable name="info-href" select="concat('https://mail.', $info/ya-domain, '/message?ids=', $info/mid)"/>

                <span class="flight-info">
                    <xsl:variable name="info-link">
                        <a href="{$info-href}" class="daria-goto-anchor" target="_blank">
                            <xsl:value-of select="ya:i18n('flight.mail.options.info.0')"/>
                        </a>
                    </xsl:variable>
                    <xsl:copy-of select="ya:i18n('flight.mail.options.info', ($info-link))"/>
                </span>
                <xsl:value-of select="' '"/>

                <xsl:variable name="check-in-link">
                    <xsl:if test="$info/check-in-link">
                        <a href="{$info/check-in-link}" target="_blank">
                            <xsl:value-of select="ya:i18n('flight.mail.options.check-in.0')"/>
                        </a>
                    </xsl:if>
                    <xsl:if test="not($info/check-in-link)">
                        <xsl:value-of select="ya:i18n('flight.mail.options.check-in.0')"/>
                    </xsl:if>
                </xsl:variable>

                <xsl:copy-of select="ya:i18n('flight.mail.options.check-in', ($check-in-link))"/>
                <br/>

                <xsl:if test="$info/aeroexpress-link">
                    <xsl:variable name="aeroexpress-link">
                        <a href="{$info/aeroexpress-link}" target="_blank">
                            <xsl:value-of select="ya:i18n('flight.mail.options.aeroexpress.0')"/>
                        </a>
                    </xsl:variable>

                    <xsl:copy-of select="ya:i18n('flight.mail.options.aeroexpress', ($aeroexpress-link))"/>
                    <br/>
                </xsl:if>
                <br/>

                <xsl:value-of select="ya:i18n('flight.mail.bye')"/>
            </body>
        </html>
    </xsl:template>

    <xsl:function name="ya:format-dateTime">
        <xsl:param name="date"/>

        <xsl:variable name="month" select="tokenize(ya:i18n('flight.mail.months'), '\|')[month-from-dateTime($date)]"/>
        <xsl:value-of select="format-dateTime($date, concat('[D] ', $month, ' ', ya:i18n('flight.mail.at'), ' [H00]:[m00]'), 'en', 'AD', '')"/>
    </xsl:function>

    <xsl:variable name="i18n" select="/flight-email-info/i18n"/>

    <xsl:function name="ya:i18n">
        <xsl:param name="key"/>

        <xsl:copy-of select="ya:i18n($key, ())"/>
    </xsl:function>

    <xsl:function name="ya:i18n">
        <xsl:param name="key"/>
        <xsl:param name="args"/>

        <xsl:copy-of select="ya:_format($i18n/key[. = $key]/../value, $args, 0)"/>
    </xsl:function>

    <xsl:function name="ya:_format">
        <xsl:param name="string"/>
        <xsl:param name="args"/>
        <xsl:param name="pos"/>

        <xsl:choose>
            <xsl:when test="$string = '' or $pos >= count($args)">
                <xsl:value-of select="$string"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="replacement" select="$args[$pos + 1]"/>
                <xsl:variable name="search" select="concat('{', $pos, '}')"/>
                <xsl:choose>
                    <xsl:when test="not(contains($string, $search))">
                        <xsl:value-of select="$string"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:copy-of select="ya:_format(substring-before($string, $search), $args, $pos + 1)"/>
                        <xsl:copy-of select="$replacement"/>
                        <xsl:copy-of select="ya:_format(substring-after($string, $search), $args, $pos + 1)"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

</xsl:stylesheet>
