<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ya="urn:yandex-functions"
                exclude-result-prefixes="ya"
                version="2.0">

    <xsl:output method="xml" encoding="utf-8"/>

    <xsl:variable name="info" select="/rich-event-email-info"/>

    <xsl:template match="/">
        <mail>
            <subject><xsl:apply-templates select="." mode="subject"/></subject>
            <html-body><xsl:apply-templates select="." mode="html-body"/></html-body>

            <image cid="yandex-reminds" src="images/yandex-reminds.png"/>
            <image cid="icon-calendar" src="images/icon-calendar.png"/>
        </mail>
    </xsl:template>

    <xsl:template match="/" mode="subject">
        <xsl:for-each select="$info/sender-name">
            <xsl:value-of select="concat('[', ., '] ')"/>
        </xsl:for-each>

        <xsl:value-of select="$info/email-subject[$info/email-subject]"/>
        <xsl:value-of select="$info/name[not($info/email-subject)]"/>
    </xsl:template>

    <xsl:template name="json-data">
        <xsl:if test="$info/json-data">
            <script type="application/ld+json">
                <xsl:value-of select="$info/json-data/text()" disable-output-escaping="yes"/>
            </script>
        </xsl:if>
    </xsl:template>

    <!-- see https://github.yandex-team.ru/Daria/mail-mails/blob/gh-pages/reminder/index.html -->
    <xsl:template match="/" mode="html-body">
        <html>
            <head>
                <meta charset="UTF-8"/>
                <title>Яндекс.Напомнит</title>
            </head>
            <body style="margin:0;padding:0;background: #f6f5f3;">
                <table border="0" cellpadding="0" cellspacing="0" width="568" align="center">
                    <tr>
                        <td valign="middle" align="center">
                            <table border="0" cellspacing="0" cellpadding="0" bgcolor="#FFFFFF" width="562" style="font-family: Arial, sans-serif; font-size: 15px; border: 1px solid #E4E4E4;">
                                <tr>
                                    <td align="center">
                                        <div style="padding: 36px 26px; text-align: left;">
                                            <img src="cid:yandex-reminds" width="240" height="38" />
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                            <xsl:apply-templates select="/" mode="content-rows"/>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>

            </body>
        </html>
    </xsl:template>

    <xsl:template match="/" mode="content-rows">
        <xsl:if test="$info/start-date">
            <tr>
                <td align="left" style="padding-bottom:5px;padding-left:26px;padding-right:26px;line-height: 21px;">
                    <img src="cid:icon-calendar" width="11" height="10" />
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="format-date($info/start-date, '[D]')"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="ya:month_g(month-from-date($info/start-date))"/>
                    <xsl:if test="$info/start-time">
                        <xsl:value-of select="concat(', в ', format-time($info/start-time, '[H00]:[m00]'))"/>
                    </xsl:if>
                    <xsl:text> состоится</xsl:text>
                </td>
            </tr>
        </xsl:if>
        <xsl:if test="$info/name or $info/sender-name">
            <tr>
                <td align="left" style="padding-bottom:30px;padding-left:26px;padding-right:26px;">
                    <h1 style="font-size:25px;line-height:1.175;margin:0;margin-bottom:6px;">
                        <xsl:value-of select="$info/name"/>
                    </h1>
                    <xsl:if test="$info/sender-name">
                        <strong>
                            <xsl:text>Напоминание создано через </xsl:text>
                            <xsl:if test="$info/sender-url">
                                <a href="{$info/sender-url}" style="text-decoration:none;color:#2E77C4;">
                                    <xsl:value-of select="$info/sender-name"/>
                                </a>
                            </xsl:if>
                            <xsl:if test="not($info/sender-url)">
                                <xsl:value-of select="$info/sender-name"/>
                            </xsl:if>
                        </strong>
                    </xsl:if>
                </td>
            </tr>
        </xsl:if>
        <xsl:if test="$info/description or $info/image-url">
            <tr>
                <td align="left" style="line-height: 21px;">
                    <table border="0" cellpadding="0" cellspacing="0" align="center" width="510">
                        <tr>
                            <xsl:if test="$info/image-url">
                                <td align="left" valign="top" style="padding-bottom:20px;padding-right:20px;">
                                    <xsl:variable name="image">
                                        <img border="0" src="{$info/image-url}" style="max-width: 120px;"/>
                                    </xsl:variable>
                                    <xsl:if test="$info/url">
                                        <a href="{$info/url}"><xsl:copy-of select="$image"/></a>
                                    </xsl:if>
                                    <xsl:if test="not($info/url)">
                                        <xsl:copy-of select="$image"/>
                                    </xsl:if>
                                </td>
                            </xsl:if>
                            <xsl:if test="$info/description">
                                <td valign="top" style="padding-bottom:20px;color:#838282;line-height:1.5">
                                    <xsl:text>Описание события: </xsl:text>
                                    <xsl:value-of select="$info/description"/>
                                    <xsl:if test="$info/url">
                                        <xsl:text> </xsl:text>
                                        <a href="{$info/url}" style="text-decoration:none;color:#2E77C4;">Подробнее</a>
                                    </xsl:if>
                                </td>
                            </xsl:if>
                        </tr>
                    </table>
                </td>
            </tr>
        </xsl:if>
        <!-- XXX
        <tr>
            <td align="left" style="padding-bottom:10px;line-height:21px;padding-left:26px;color:#444;">
                <img src="icon-compass.png" width="12" height="12" style="margin-right:3px;" />
                Кинотеатр «Октябрь»
            </td>
        </tr>
        <tr>
            <td align="left" style="padding-bottom:50px;line-height: 21px;">
                <a href="#x">
                    <img border="0" src="map.jpg" width="562" height="255">
                </a>
            </td>
        </tr>
        <tr>
            <td align="left" style="line-height: 21px;">
                <table border="0" cellpadding="0" cellspacing="0" align="center" width="510">
                    <tr>
                        <td valign="middle" align="left" width="36px" style="padding-bottom:26px;">
                            <img src="upic1.jpg" width="36" height="36" style="vertical-align:middle;padding-right:6px" />
                        </td>
                        <td valign="middle" align="left" width="50%" style="padding-bottom:26px;">
                            Макс Максимов
                        </td>
                        <td valign="middle" align="left" width="36px" style="padding-bottom:26px;">
                            <img src="upic2.jpg" width="36" height="36" style="vertical-align:middle;padding-right:6px" />
                        </td>
                        <td valign="middle" align="left" width="50%" style="padding-bottom:26px;">
                            Алексей Баландин
                        </td>
                    </tr>
                    <tr>
                        <td valign="middle" align="left" width="36px" style="padding-bottom:26px;">
                            <img src="upic3.jpg" width="36" height="36" style="vertical-align:middle;padding-right:6px" />
                        </td>
                        <td valign="middle" align="left" width="50%" style="padding-bottom:26px;">
                            Виктор Грищенко
                        </td>
                        <td valign="middle" align="left" width="36px" style="padding-bottom:26px;">
                            <img src="upic4.jpg" width="36" height="36" style="vertical-align:middle;padding-right:6px" />
                        </td>
                        <td valign="middle" align="left" width="50%" style="padding-bottom:26px;">
                            Виктор Грищенко
                        </td>
                    </tr>
                    <tr>
                        <td valign="middle" align="left" width="36px" style="padding-bottom:26px;">
                            <img src="upic1.jpg" width="36" height="36" style="vertical-align:middle;padding-right:6px" />
                        </td>
                        <td valign="middle" align="left" width="50%" style="padding-bottom:26px;">
                            Константин Константинопольский
                        </td>
                        <td valign="middle" align="left" width="36px" style="padding-bottom:26px;">
                            <img src="upic2.jpg" width="36" height="36" style="vertical-align:middle;padding-right:6px" />
                        </td>
                        <td valign="middle" align="left" width="50%" style="padding-bottom:26px;">
                            Алексей Баландин
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        -->
        <tr>
            <xsl:if test="$info/end-date or $info/end-time or $info/duration">
                <td align="left" style="padding-bottom:60px;padding-left:26px;padding-right:26px;color:#494949;line-height:1.5">
                    <xsl:if test="$info/duration">
                        <xsl:variable name="hours" select="hours-from-duration($info/duration)"/>
                        <xsl:variable name="minutes" select="minutes-from-duration($info/duration)"/>

                        <xsl:text>Продолжительность события: </xsl:text>
                        <xsl:if test="$hours > 0">
                            <xsl:value-of select="concat($hours, ' ', ya:hour_pl($hours))"/>
                            <xsl:text> </xsl:text>
                            <xsl:value-of select="concat(format-number($minutes, '00'), ' ', ya:minute_pl($minutes))"/>
                        </xsl:if>
                        <xsl:if test="0 >= $hours">
                            <xsl:value-of select="concat($minutes, ' ', ya:minute_pl($minutes))"/>
                        </xsl:if>
                        <br/>
                    </xsl:if>
                    <xsl:if test="$info/end-time">
                        <xsl:text>Время окончания: </xsl:text>
                        <xsl:value-of select="format-time($info/end-time, '[H00]:[m00]')"/>
                    </xsl:if>
                </td>
            </xsl:if>
        </tr>
        <tr>
            <td align="left" style="padding-bottom:20px;padding-left:26px;padding-right:26px;color:#494949;line-height:1.5;color:#AAA8A8;font-size:12px">
                <xsl:text>Уведомление отправлено через </xsl:text>
                <a href="https://calendar.yandex.ru" style="text-decoration:none;color:#2E77C4;">Яндекс.Календарь</a>
                <xsl:text>. © 2007–</xsl:text>
                <xsl:value-of select="format-date(current-date(), '[Y]')"/>
                <xsl:text> «Яндекс»</xsl:text>
            </td>
        </tr>
    </xsl:template>

    <xsl:function name="ya:month_g">
        <xsl:param name="month"/>

        <xsl:variable name="months" select="
                'января', 'февраля', 'марта', 'апреля', 'мая', 'июня',
                'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря'"/>

        <xsl:value-of select="$months[$month]"/>
    </xsl:function>

    <xsl:function name="ya:hour_pl">
        <xsl:param name="count"/>
        <xsl:variable name="hours" select="'час', 'часа', 'часов'"/>
        <xsl:value-of select="ya:pluralize-form($hours, $count)"/>
    </xsl:function>

    <xsl:function name="ya:minute_pl">
        <xsl:param name="count"/>
        <xsl:variable name="hours" select="'минута', 'минуты', 'минут'"/>
        <xsl:value-of select="ya:pluralize-form($hours, $count)"/>
    </xsl:function>

    <xsl:function name="ya:pluralize-form">
        <xsl:param name="dict"/>
        <xsl:param name="count"/>

        <xsl:variable name="mod100" select="$count mod 100"/>
        <xsl:variable name="mod10" select="$count mod 100"/>

        <xsl:variable name="_11_to_14" select="$mod100 > 10 and 15 > $mod10"/>
        <xsl:choose>
            <xsl:when test="$mod10 = 1 and not($_11_to_14)">
                <xsl:value-of select="$dict[1]"/>
            </xsl:when>
            <xsl:when test="$mod10 > 1 and 5 > $mod10 and not($_11_to_14)">
                <xsl:value-of select="$dict[2]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$dict[3]"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>

</xsl:stylesheet>