package ru.yandex.reminders.logic.sup;

import org.joda.time.DateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderTextValue;
import ru.yandex.reminders.api.DateTimeConverters;

/**
 * @author dbrylev
 */
@Bendable
public class DateTimeOrNow {

    private final Option<DateTime> dateTime;

    private DateTimeOrNow(Option<DateTime> dateTime) {
        this.dateTime = dateTime;
    }

    public static DateTimeOrNow dateTime(DateTime date) {
        return new DateTimeOrNow(Option.of(date));
    }

    public static DateTimeOrNow now() {
        return new DateTimeOrNow(Option.empty());
    }

    public Option<DateTime> getDateTime() {
        return dateTime;
    }

    @BenderTextValue
    public static DateTimeOrNow parse(String value) {
        return value.equals("now") ? now() : dateTime(DateTimeConverters.dateTimeWithTzConverter.parse(value));
    }

    @BenderTextValue
    public String serialize() {
        return dateTime.map(DateTimeConverters.dateTimeWithTzConverter::toString).getOrElse("now");
    }
}
