package ru.yandex.reminders.logic.sup;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.reminders.boot.RemindersZkContextConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        RemindersZkContextConfiguration.class,
})
public class SupClientContextConfiguration {

    @Bean
    public SupClientSettingsRegistry supClientSettingsRegistry(
            @Qualifier("zkRoot") ZkPath zkRoot, ZkManager manager)
    {
        SupClientSettingsRegistry registry = new SupClientSettingsRegistry(zkRoot.child("sup-settings"));
        manager.addClient(registry);

        return registry;
    }
}
