package ru.yandex.reminders.logic.sup;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.bender.JsonValueMarshaller;
import ru.yandex.commune.json.bender.JsonValueUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;

/**
 * @author dbrylev
 */
@Data
@BenderBindAllFields
public class SupClientSettings {

    public static final BenderMapper benderMapper = new BenderMapper(BenderConfiguration.cons(
            MembersToBind.WITH_ANNOTATIONS, false, CustomMarshallerUnmarshallerFactoryBuilder.cons()
                    .add(JsonObject.class, new JsonValueMarshaller(), new JsonValueUnmarshaller())
                    .build()));

    private final String clientId;
    private final String oAuthToken;
    private final String receiverExpression;
    private final String priority;

    private final SupPushRequest push;

    private final Option<String> xivaPushToken;

    public SupPushParameters getRequestParameters() {
        return new SupPushParameters(priority, oAuthToken);
    }
}
