package ru.yandex.reminders.logic.sup;

import org.apache.http.HttpResponse;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.inside.utils.OAuthAuthenticationHandler;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

import java.io.IOException;

public class SupPushClient extends PushClientSupport<SupPushRequest, JsonObject> {

    private static final Logger logger = LoggerFactory.getLogger(SupPushClient.class);

    public SupPushClient(String url, int maxCons, Timeout timeout) {
        super(url, maxCons, timeout);
    }

    public String push(SupPushRequest request, SupPushParameters params) {
        JsonObject result = execute(Tuple2List.fromPairs("priority", params.getPriority()), request,
                new OAuthAuthenticationHandler(params.getOAuthToken())::handle, this::parseResponse);

        Option<JsonArray> logs = result.getO("logs").filterByType(JsonArray.class);
        if (logs.isPresent()) {
            logs.get().getArray().iterator().forEachRemaining(line -> {
                if (line instanceof JsonString) {
                    logger.debug(((JsonString) line).getString());
                }
            });
        }
        return ((JsonString) result.get("id")).getValue();
    }

    private JsonObject parseResponse(HttpResponse response) throws IOException {
        return JsonObject.parseObject(InputStreamSourceUtils.wrap(response.getEntity().getContent()).readText());
    }
}
