package ru.yandex.reminders.logic.sup;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.misc.io.http.Timeout;

@Configuration
@Import({
        SupClientContextConfiguration.class,
})
public class SupPushContextConfiguration {

    @Bean
    public SupPushClient supPushClient(
            @Value("${sup.push.url}") String url,
            @Value("${sup.push.timeout.secs}") int timeoutSeconds,
            @Value("${sup.push.maxConnections}") int maxConnections) {
        return new SupPushClient(url, maxConnections, Timeout.seconds(timeoutSeconds));
    }

    @Bean
    public XivaPushClient xivaPushClient(
            @Value("${xiva.push.url}") String url,
            @Value("${xiva.push.timeout.secs}") int timeoutSeconds,
            @Value("${xiva.push.maxConnections}") int maxConnections) {
        return new XivaPushClient(url, maxConnections, Timeout.seconds(timeoutSeconds));
    }

    @Bean
    public SupPushManager supPushManager(
            SupPushClient supClient, XivaPushClient xivaClient, SupClientSettingsRegistry settingsRegistry) {
        return new SupPushManager(supClient, xivaClient, settingsRegistry);
    }
}
