package ru.yandex.reminders.logic.sup;

import lombok.Data;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @link https://push-beta.n.yandex-team.ru/docs/api-guide.html#_request_structure
 */
@Data
@BenderBindAllFields
@SuppressWarnings("UnusedAssignment")
public class SupPushRequest {

    public static final BenderParserSerializer<SupPushRequest> bender =
            SupClientSettings.benderMapper.createParserSerializer(SupPushRequest.class);

    private Option<Integer> ttl = Option.empty();
    private ListF<String> receiver = Option.empty();

    private Option<DateTimeOrNow> schedule = Option.empty();
    @BenderPart(name = "send_time_frame", strictName = true)
    private Option<String> sendTimeFrame = Option.empty();

    private Option<PushData> data = Option.empty();
    private Option<JsonObject> card = Option.empty();
    private Option<Notification> notification = Option.empty();

    @BenderPart(name = "android_features", strictName = true)
    private Option<Android> androidFeatures = Option.empty();
    @BenderPart(name = "ios_features", strictName = true)
    private Option<Ios> iosFeatures = Option.empty();

    private Option<String> project = Option.empty();
    private Option<Boolean> adjustTimeZone = Option.empty();

    @BenderPart(name = "exp_id", strictName = true)
    private Option<String> expId = Option.empty();
    @BenderPart(name = "max_expected_receivers", strictName = true)
    private Option<Integer> maxExpectedReceivers = Option.empty();

    @BenderPart(name = "throttle_policies", strictName = true)
    private Option<JsonObject> throttlePolicies = Option.empty();
    @BenderPart(name = "skip_default_patch", strictName = true)
    private Option<Boolean> skipDefaultPatch = Option.empty();

    @BenderPart(name = "is_data_only", strictName = true)
    private Option<Boolean> isDataOnly = Option.empty();
    @BenderPart(name = "spread_interval", strictName = true)
    private Option<Integer> spreadInterval = Option.empty();

    private Option<String> transport = Option.empty();

    public SupPushRequest copy() {
        return bender.getParser().parseJson(bender.getSerializer().serializeJson(this));
    }

    @Data
    @BenderBindAllFields
    public static class PushData {
        @BenderPart(name = "push_id", strictName = true)
        private Option<String> pushId = Option.empty();
        @BenderPart(name = "push_action", strictName = true)
        private Option<String> pushAction = Option.empty();
        @BenderPart(name = "push_uri", strictName = true)
        private Option<String> pushUri = Option.empty();
        @BenderPart(name = "topic_push", strictName = true)
        private Option<String> pushTopic = Option.empty();
    }

    @Data
    @BenderBindAllFields
    public static class Notification {
        private Option<String> title = Option.empty();
        private Option<String> body = Option.empty();
        private Option<String> icon = Option.empty();
    }

    @Data
    @BenderBindAllFields
    public static class Android {
        private Option<Boolean> vibrationOn = Option.empty();
        private Option<Boolean> silent = Option.empty();
        private Option<Integer> priority = Option.empty();
        private Option<Integer> soundType = Option.empty();
        private Option<Integer> ledType = Option.empty();
        private Option<String> group = Option.empty();
        private Option<Integer> counter = Option.empty();
        private Option<Long> timestamp = Option.empty();
    }

    @Data
    @BenderBindAllFields
    public static class Ios {
        @BenderPart(name = "content_available", strictName = true)
        private Option<Boolean> contentAvailable = Option.empty();
        @BenderPart(name = "mutable_content", strictName = true)
        private Option<Boolean> mutableContent = Option.empty();
        private Option<Integer> soundType = Option.empty();
    }
}
