package ru.yandex.reminders.logic.sup;

import org.apache.http.Header;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpRequestWrapper;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.io.http.Timeout;

public class XivaPushClient extends PushClientSupport<XivaPushRequest, String> {

    public XivaPushClient(String url, int maxCons, Timeout timeout) {
        super(url, maxCons, timeout);
    }

    public String push(PassportUid uid, XivaPushRequest request, String authToken) {
        return execute(Tuple2List.fromPairs("user", uid, "event", "reminder"), request,
                req -> {
                    HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(req);
                    wrapper.removeHeaders(HttpHeaders.AUTHORIZATION);
                    wrapper.addHeader(HttpHeaders.AUTHORIZATION, "Xiva " + authToken);

                    return wrapper;
                },
                resp -> Option.ofNullable(resp.getFirstHeader("TransitID")).map(Header::getValue).getOrElse("unknown"));
    }
}
